% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{stanplot.brmsfit}
\alias{stanplot}
\alias{stanplot.brmsfit}
\title{Various Plotting Functions implemented in \pkg{rstan}}
\usage{
\method{stanplot}{brmsfit}(object, pars = NA, type = "plot",
  exact_match = FALSE, quiet = FALSE, ...)

stanplot(object, pars, ...)
}
\arguments{
\item{object}{An R object typically of class \code{brmsfit}}

\item{pars}{Names of parameters to be plotted, 
as given by a character vector or regular expressions. 
By default, the first 10 parameters are plotted.}

\item{type}{The type of the plot. 
Supported types are (as names) \code{plot},
\code{trace}, \code{hist}, \code{dens}, \code{scat}, 
\code{diag}, \code{rhat}, \code{ess}, \code{mcse}, \code{ac}. 
For an overview on the various plot types see
\code{\link[rstan:plotting-functions]{plotting-functions}}.}

\item{exact_match}{Indicates whether parameter names 
should be matched exactly or treated as regular expression. 
Default is \code{FALSE}.}

\item{quiet}{A flag indicating whether messages 
produced by \pkg{ggplot2} during the plotting process 
should be silenced. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to the plotting functions.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object 
  that can be further customized using the \pkg{ggplot2} package.
}
\description{
Conveniant way to call plotting functions 
implemented in the \pkg{rstan} package.
}
\details{
Instead of using \code{stanplot(<brmsfit-object>)}, 
  the plotting functions can be called directly 
  via \code{stan_<plot-type>(<brmsfit-object>$fit)}. 
  For more details on the plotting functions see 
  \code{\link[rstan:stan_plot]{Plots}} as well as 
  \code{\link[rstan:stan_diag]{Diagnostic plots}}.
  Note that the plotting functions themselves 
  only accept full parameter names,
  while \code{stanplot} allows for partial matching 
  and regular expressions.
  You should also consider using 
  the \pkg{shinystan} package available via method 
  \code{\link[brms:launch_shiny]{launch_shiny}} 
  in \pkg{brms} for flexible and interactive visual analysis.
}
\examples{
\dontrun{
model <- brm(count ~ log_Age_c + log_Base4_c * Trt_c 
             + (1|patient) + (1|visit),
             data = epilepsy, family = "poisson")
# plot 95\% CIs
stanplot(model, type = "plot", ci_level = 0.95)
# equivalent to
stan_plot(model$fit, ci_level = 0.95)

# only show fixed effects in the plots
# this will not work when calling stan_plot directly
stanplot(model, pars = "^b", type = "plot", ci_level = 0.95)

# plot some diagnostics on the sampler
stanplot(model, type = "diag")
# equivalent to 
stan_diag(model$fit)                           
}

}

