% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{pairs.brmsfit}
\alias{pairs.brmsfit}
\title{Create a matrix of output plots from a \code{brmsfit} object}
\usage{
\method{pairs}{brmsfit}(x, pars = NA, exact_match = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}}

\item{pars}{Names of parameters for which posterior samples 
should be returned, as given by a character vector or regular expressions.
By default, all posterior samples of all parameters are extracted.}

\item{exact_match}{Indicates whether parameter names 
should be matched exactly or treated as regular expression. 
Default is \code{FALSE}.}

\item{...}{Further arguments to be passed to 
\code{\link[bayesplot:mcmc_pairs]{mcmc_pairs}}.}
}
\description{
A \code{\link[graphics:pairs]{pairs}} 
method that is customized for MCMC output.
}
\details{
For a detailed description see  
  \code{\link[bayesplot:mcmc_pairs]{mcmc_pairs}}.
}
\examples{
\dontrun{
fit <- brm(count ~ zAge + zBase * Trt 
           + (1|patient) + (1|visit), 
           data = epilepsy, family = "poisson")  
pairs(fit, pars = parnames(fit)[1:3], exact_match = TRUE)
pairs(fit, pars = "^sd_")
}

}
