% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.links}
\alias{.links}
\title{Convert a Link Function Name to a List}
\usage{
.links(
  link,
  effects = c("fixedonly", "includeRE", "integrateoutRE"),
  backtrans = c("response", "linear", "identity", "invlogit", "exp", "square")
)
}
\arguments{
\item{link}{The link named in a \code{brmsfit} object}

\item{effects}{A character string, the type of effect desired}

\item{backtrans}{A character string, the type of back transformation}
}
\value{
A list with four elements.
\describe{
\item{scale}{A character string giving the argument to be passed to \code{\link[=fitted]{fitted()}}.}
\item{ilink}{A character string giving the name of the inverse link function.}
\item{ifun}{Inverse link function as an \code{R} function.}
\item{ilinknum}{An integer giving the inverse link / transformation to be applied in \code{\link[=integratere]{integratere()}}, needed as this is a C++ function and cannot use the \code{R} based inverse link function.}
}
}
\description{
Internal utility function used in \code{\link[=prediction]{prediction()}}.
Takes a link function name as a character string,
the type of effect to be used, and the desired back transformation
and returns a list with all the options needed to execute the desired
options in \code{\link[=prediction]{prediction()}}.
}
\keyword{internal}
