% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa03_broadcast_bind.R, R/bind_array.R
\name{bind_array}
\alias{bind_array}
\title{Dimensional Binding of Arrays with Broadcasting}
\usage{
bind_array(
  input,
  along,
  rev = FALSE,
  ndim2bc = 16L,
  name_along = TRUE,
  comnames_from = 1L
)
}
\arguments{
\item{input}{a list of arrays; both atomic and recursive arrays are supported, and can be mixed. \cr
If argument \code{input} has length \code{0},
or it contains exclusively objects where one or more dimensions are \code{0},
an error is returned. \cr
If \code{input} has length \code{1}, \code{bind_array()} simply returns \code{input[[1L]]}. \cr
\code{input} may not contain more than \code{2^16} objects.}

\item{along}{a single integer,
indicating the dimension along which to bind the dimensions. \cr
I.e. use \code{along = 1} for row-binding, \code{along = 2} for column-binding, etc. \cr
Specifying \code{along = 0} will bind the arrays on a new dimension before the first,
making \code{along} the new first dimension. \cr
Specifying \code{along = N + 1}, with \code{N = max(lst.ndim(input))},
will create an additional dimension (\code{N + 1}) and bind the arrays along that new dimension.}

\item{rev}{Boolean, indicating if \code{along} should be reversed, counting backwards. \cr
If \code{FALSE} (default), \code{along} works like normally; if \code{TRUE}, \code{along} is reversed. \cr
I.e. \verb{along = 0, rev = TRUE} is equivalent to \verb{along = N+1, rev = FALSE}; \cr
and \verb{along = N+1, rev = TRUE} is equivalent to \verb{along = 0, rev = FALSE}; \cr
with \code{N = max(lst.ndim(input))}.}

\item{ndim2bc}{a single non-negative integer; \cr
specify here the maximum number of dimensions that are allowed to be broadcasted when binding arrays. \cr
If \code{ndim2bc = 0L}, \bold{no} broadcasting will be allowed at all.}

\item{name_along}{Boolean, indicating if dimension \code{along} should be named. \cr
Please run the code in the examples section to get a demonstration of the naming behaviour.}

\item{comnames_from}{either an integer scalar or \code{NULL}. \cr
Indicates which object in \code{input} should be used for naming the shared dimension. \cr
If \code{NULL}, no communal names will be given. \cr
For example: \cr
When binding columns of matrices, the matrices will share the same rownames. \cr
Using \code{comnames_from = 10} will then result in \code{bind_array()} using
\code{rownames(input[[10]])} for the rownames of the output. \cr \cr}
}
\value{
An array. \cr  \cr
}
\description{
\code{bind_array()} binds (atomic/recursive) arrays and (atomic/recursive) matrices. \cr
Allows for broadcasting. \cr \cr
}
\details{
The API of \code{bind_array()} is inspired by the fantastic
\code{abind::abind()} function
by Tony Plare & Richard Heiberger (2016). \cr
But \code{bind_array()} differs considerably from \code{abind::abind}
in the following ways:
\itemize{
\item \code{bind_array()} allows for broadcasting,
while \code{abind::abind} does not support broadcasting.
\item \code{bind_array()} is generally faster and more memory-efficient than \code{abind::abind},
as \code{bind_array()} relies heavily on 'C' and 'C++' code.
\item \code{bind_array()} differs from \code{abind::abind}
in that it can handle recursive arrays properly \cr
(the \code{abind::abind} function would unlist everything to atomic arrays,
ruining the structure).
\item unlike \code{abind::abind},
\code{bind_array()} only binds (atomic/recursive) arrays and matrices. \cr
\code{bind_array()}does not attempt to convert things to arrays when they are not arrays,
but will give an error instead. \cr
This saves computation time and prevents unexpected results.
\item \code{bind_array()} has more streamlined naming options,
compared to \code{abind::abind}. \cr
}
}
\examples{

# Simple example ====
x <- array(1:20, c(5, 4))
y <- array(-1:-15, c(5, 3))
z <- array(21:40, c(5, 4))
input <- list(x, y, z)
# column binding:
bind_array(input, 2L)


# Broadcasting example ====
x <- array(1:20, c(5, 4))
y <- array(-1:-5, c(5, 1))
z <- array(21:40, c(5, 4))
input <- list(x, y, z)
bind_array(input, 2L)


# Mixing types ====
# here, atomic and recursive arrays are mixed,
# resulting in recursive arrays

# creating the arrays:
x <- c(
  lapply(1:3, \(x)sample(c(TRUE, FALSE, NA))),
  lapply(1:3, \(x)sample(1:10)),
  lapply(1:3, \(x)rnorm(10)),
  lapply(1:3, \(x)sample(letters))
) |> matrix(4, 3, byrow = TRUE)
dimnames(x) <- list(letters[1:4], LETTERS[1:3])
print(x)

y <- matrix(1:12, 4, 3)
print(y)
z <- matrix(letters[1:12], c(4, 3))

# column-binding:
input <- list(x = x, y = y, z = z)
bind_array(input, along = 2L)



# Illustrating `along` argument ====
# using recursive arrays for clearer visual distinction
input <- list(x = x, y = y)

bind_array(input, along = 0L) # binds on new dimension before first
bind_array(input, along = 1L) # binds on first dimension (i.e. rows)
bind_array(input, along = 2L)
bind_array(input, along = 3L) # bind on new dimension after last

bind_array(input, along = 0L, TRUE) # binds on new dimension after last
bind_array(input, along = 1L, TRUE) # binds on last dimension (i.e. columns)
bind_array(input, along = 2L, TRUE)
bind_array(input, along = 3L, TRUE) # bind on new dimension before first



# binding, with empty arrays ====
emptyarray <- array(numeric(0L), c(0L, 3L))
dimnames(emptyarray) <- list(NULL, paste("empty", 1:3))
print(emptyarray)
input <- list(x = x, y = emptyarray)
bind_array(input, along = 1L, comnames_from = 2L) # row-bind



# Illustrating `name_along` ====
x <- array(1:20, c(5, 3), list(NULL, LETTERS[1:3]))
y <- array(-1:-20, c(5, 3))
z <- array(-1:-20, c(5, 3))

bind_array(list(a = x, b = y, z), 2L)
bind_array(list(x, y, z), 2L)
bind_array(list(a = unname(x), b = y, c = z), 2L)
bind_array(list(x, a = y, b = z), 2L)
input <- list(x, y, z)
names(input) <- c("", NA, "")
bind_array(input, 2L)


}
\references{
Plate T, Heiberger R (2016). \emph{abind: Combine Multidimensional Arrays}. R package version 1.4-5, \url{https://CRAN.R-project.org/package=abind}.
}
