% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_control.R
\name{set_control}
\alias{set_control}
\title{Set controls to steer calculations}
\usage{
set_control(
  method = c("kr", "lmer"),
  kr = control_kr(...),
  lmer = lmerControl(check.nobs.vs.nRE = "warning"),
  ...
)
}
\arguments{
\item{method}{String indicating estimation method: \code{"kr"} or \code{"lmer"}}

\item{kr}{A list generated by \link{control_kr}.}

\item{lmer}{A list generated by \link[lme4:lmerControl]{lme4::lmerControl}. The default
is set to \code{lmerControl(check.nobs.vs.nRE = "warning")}, which turns
fatal errors with respect the number of parameters into warnings. Use
\code{lmerControl(check.nobs.vs.nRE = "ignore")} to silence \code{lmer()}.}

\item{\dots}{Forwards arguments to \code{\link[=control_kr]{control_kr()}}}
}
\value{
For method \code{"kr"}, a list returned by \code{\link[=control_kr]{control_kr()}}.
For method \code{"lmer"}, an object of class \code{lmerControl}.
For other methods, \code{set_control()} returns \code{NULL}.
}
\description{
Set controls to steer calculations
}
\examples{
# defaults
control <- set_control()
control
}
