% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys_near.R
\name{keys_near.tbl_ts}
\alias{keys_near.tbl_ts}
\title{Return keys nearest to a given statistics or summary.}
\usage{
\method{keys_near}{tbl_ts}(.data, var, top_n = 1, funs = l_five_num, stat_as_factor = TRUE, ...)
}
\arguments{
\item{.data}{tsibble}

\item{var}{variable to summarise}

\item{top_n}{top number of closest observations to return - default is 1, which will also return ties.}

\item{funs}{named list of functions to summarise by. Default is a given
list of the five number summary, \code{l_five_num}.}

\item{stat_as_factor}{coerce \code{stat} variable into a factor? Default is TRUE.}

\item{...}{extra arguments to pass to \code{mutate_at} when performing the summary
as given by \code{funs}.}
}
\description{
Return keys nearest to a given statistics or summary.
}
\examples{
               
# Return observations closest to the five number summary of height_cm
heights \%>\%
  keys_near(var = height_cm)
               
}
