% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holmans_triangle.R
\name{triarrow}
\alias{triarrow}
\title{Plot an arrow within a Holmans triangle}
\usage{
triarrow(x, ...)
}
\arguments{
\item{x}{A matrix with three rows and two columns, each column being a trinomial
distribution.  An arrow between the two points is plotted.}

\item{...}{Passed to \code{\link[graphics]{arrows}}.}
}
\value{
The (x,y) coordinates of the endpoints of the arrows plotted.
}
\description{
Plot an arrow within a Holmans triangle (an equilateral triangle used to depict
  trinomial distributions).
}
\details{
Plot of an equilateral triangle, in order to depict trinomial
  distributions.  A trinomial distribution (that is, a trio of
  non-negative numbers that add to 1) is equated to a point in the
  triangle through the distances to the three sides.  This makes use of
  the fact that for any point in an equilateral triangle, the sum of the
  distances to the three sides is constant.
  First use \code{\link{triplot}} to first plot the equilateral triangle.
}
\examples{
triplot()
x <- cbind(c(0.9, 0.05, 0.05), c(0.8, 0.1, 0.1), c(0.1, 0.9, 0), c(0, 0.9, 0.1))
tripoints(x, lwd=2, col=c("black","blue","red","green"), pch=16)
trilines(x, lwd=2, col="orange")
y <- cbind(c(0.05, 0.05, 0.9), c(0.25, 0.25, 0.5))
triarrow(y, col="blue", lwd=2, len=0.1)

}
\seealso{
\code{\link{triplot}}, \code{\link{tripoints}},
  \code{\link{trilines}}
}
\keyword{hplot}
