% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_tidiers.R
\name{nlme_tidiers}
\alias{nlme_tidiers}
\alias{tidy.lme}
\alias{augment.lme}
\alias{glance.lme}
\alias{tidy.gls}
\title{Tidying methods for mixed effects models}
\usage{
\method{tidy}{lme}(x, effects = c("ran_pars", "fixed"), scales = NULL,
  conf.int = FALSE, conf.level = 0.95, ...)

\method{augment}{lme}(x, data = x$data, newdata, ...)

\method{glance}{lme}(x, ...)

\method{tidy}{gls}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An object of class \code{lme}, such as those from \code{lme}
or \code{nlme}}

\item{effects}{Either "random" (default) or "fixed"}

\item{scales}{scales on which to report the variables: for random effects, the choices are \sQuote{"sdcor"} (standard deviations and correlations: the default if \code{scales} is \code{NULL}) or \sQuote{"vcov"} (variances and covariances). \code{NA} means no transformation, appropriate e.g. for fixed effects; inverse-link transformations (exponentiation or logistic) are not yet implemented, but may be in the future.}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{...}{extra arguments (not used)}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed}

\item{newdata}{new data to be used for prediction; optional}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect, either
random or fixed depending on the \code{effects} parameter. If
\code{effects = "random"}, it contains the columns
  \item{group}{the group within which the random effect is being estimated}
  \item{level}{level within group}
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}

If \code{effects="fixed"}, \code{tidy} returns the columns
  \item{term}{fixed term being estimated}
  \item{estimate}{estimate of fixed effect}
  \item{std.error}{standard error}
  \item{statistic}{t-statistic}
  \item{p.value}{P-value computed from t-statistic}

\code{augment} returns one row for each original observation,
with columns (each prepended by a .) added. Included are the columns
  \item{.fitted}{predicted values}
  \item{.resid}{residuals}
  \item{.fixed}{predicted values with no random effects}

\code{glance} returns one row with the columns
  \item{sigma}{the square root of the estimated residual variance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{returned as NA. To quote Brian Ripley on R-help
\url{https://stat.ethz.ch/pipermail/r-help/2006-May/104744.html},
 "McCullagh & Nelder (1989) would be the authorative [sic] reference, but the 1982
first edition manages to use 'deviance' in three separate senses on one
page." }
}
\description{
These methods tidy the coefficients of mixed effects models
of the \code{lme} class from functions  of the \code{nlme} package.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{

if (require("nlme") && require("lme4")) {
    data("sleepstudy", package="lme4")
    ## original model
    \dontrun{
         lmm1 <- lme(Reaction ~ Days, random=~ Days|Subject, sleepstudy)
    }
    ## load stored object
    load(system.file("extdata","nlme_example.rda", package="broom.mixed"))
    tidy(lmm1)
    tidy(lmm1, effects = "fixed")
    tidy(lmm1, conf.int = TRUE)
    head(augment(lmm1, sleepstudy))
    glance(lmm1)

    startvec <- c(Asym = 200, xmid = 725, scal = 350)
    nm1 <- nlme(circumference ~ SSlogis(age, Asym, xmid, scal),
                  data = Orange,
                  fixed = Asym + xmid + scal ~1,
                  random = Asym ~1,
                  start = startvec)
    tidy(nm1)
    tidy(nm1, effects = "fixed")
    head(augment(nm1, Orange))
    glance(nm1)

    gls1 <- gls(follicles ~ sin(2*pi*Time) + cos(2*pi*Time), Ovary,
                         correlation = corAR1(form = ~ 1 | Mare))
    tidy(gls1)
    glance(gls1)
}

}
\seealso{
\link{na.action}
}
