% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gam_tidiers.R
\name{gam_tidiers}
\alias{gam_tidiers}
\alias{glance.gam}
\alias{tidy.gam}
\title{Tidying methods for a generalized additive model (gam)}
\usage{
\method{tidy}{gam}(x, ...)

\method{glance}{gam}(x, ...)
}
\arguments{
\item{x}{gam object}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.gam} returns the tidied output of the
parametric ANOVA, with one row for each term in the formula.
The columns match those in \link{anova_tidiers}.

\code{glance.gam} returns a one-row data.frame with the columns
  \item{df}{Degrees of freedom used by the coefficients}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
  \item{df.residual}{residual degrees of freedom}
}
\description{
These methods tidy the coefficients of a "gam" object (generalized additive
model) into a summary, augment the original data with information on the
fitted values and residuals, and construct a one-row glance of the model's
statistics.
}
\details{
The "augment" method is handled by \link{lm_tidiers}.
}
\examples{
if (require("gam", quietly = TRUE)) {
    data(kyphosis)
    g <- gam(Kyphosis ~ s(Age,4) + Number, family = binomial, data = kyphosis)
    tidy(g)
    augment(g)
    glance(g)
}
}
\seealso{
\link{lm_tidiers}, \link{anova_tidiers}
}

