% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistr_tidiers.R
\name{fitdistr_tidiers}
\alias{fitdistr_tidiers}
\alias{glance.fitdistr}
\alias{tidy.fitdistr}
\title{Tidying methods for fitdistr objects from the MASS package}
\usage{
\method{tidy}{fitdistr}(x, ...)

\method{glance}{fitdistr}(x, ...)
}
\arguments{
\item{x}{An object of class "fitdistr"}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.fitdistr} returns one row for each parameter that
was estimated, with columns:
  \item{term}{The term that was estimated}
  \item{estimate}{Estimated value}
  \item{std.error}{Standard error of estimate}

\code{glance.fitdistr} returns a one-row data.frame with the columns
  \item{n}{Number of observations used in estimation}
  \item{logLik}{log-likelihood of estimated data}
  \item{AIC}{Akaike Information Criterion}
  \item{BIC}{Bayesian Information Criterion}
}
\description{
These methods tidies the parameter estimates resulting
from an estimation of a univariate distribution's parameters.
}
\examples{

set.seed(2015)
x <- rnorm(100, 5, 2)

library(MASS)
fit <- fitdistr(x, dnorm, list(mean = 3, sd = 1))

tidy(fit)
glance(fit)
}

