% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantreg-rq-tidiers.R
\name{tidy.rq}
\alias{tidy.rq}
\alias{rq_tidiers}
\alias{quantreg_tidiers}
\title{Tidy a(n) rq object}
\usage{
\method{tidy}{rq}(x, se.type = "rank", conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An \code{rq} object returned from \code{\link[quantreg:rq]{quantreg::rq()}}.}

\item{se.type}{Character specifying the method to use to calculate
standard errors. Passed to \code{\link[quantreg:summary.rq]{quantreg::summary.rq()}} \code{se} argument.
Defaults to \code{"rank"}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments passed to \code{\link[quantreg:summary.rq]{quantreg::summary.rq()}}.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with one row for each term in the
regression. The tibble has columns:

\item{term}{The name of the regression term.}
\item{estimate}{The estimated value of the regression term.}
\item{std.error}{The standard error of the regression term.}
\item{statistic}{The value of a statistic, almost always a T-statistic,
to use in a hypothesis that the regression term is non-zero.}
\item{p.value}{The two-sided p-value associated with the observed
statistic.}
\item{conf.low}{The low end of a confidence interval for the regression
term. Included only if \code{conf.int = TRUE}.}
\item{conf.high}{The high end of a confidence interval for the regression
term. Included only if \code{conf.int = TRUE}.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
If \code{se.type = "rank"} confidence intervals are calculated by
\code{summary.rq}. When only a single predictor is included in the model,
no confidence intervals are calculated and the confidence limits are
set to NA.
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[quantreg:rq]{quantreg::rq()}}

Other quantreg tidiers: 
\code{\link{augment.nlrq}()},
\code{\link{augment.rqs}()},
\code{\link{augment.rq}()},
\code{\link{glance.nlrq}()},
\code{\link{glance.rq}()},
\code{\link{tidy.nlrq}()},
\code{\link{tidy.rqs}()}
}
\concept{quantreg tidiers}
