% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btergm-tidiers.R
\name{tidy.btergm}
\alias{tidy.btergm}
\alias{btergm_tidiers}
\title{Tidy a(n) btergm object}
\usage{
\method{tidy}{btergm}(x, conf.level = 0.95, exponentiate = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link[btergm:btergm]{btergm::btergm()}} object.}

\item{conf.level}{Confidence level for confidence intervals. Defaults to
0.95.}

\item{exponentiate}{Logical indicating whether or not to exponentiate the
the coefficient estimates. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults
to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.level = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.

This method tidies the coefficients of a bootstrapped
temporal exponential random graph model estimated with the \pkg{xergm}.
It simply returns the coefficients and their confidence intervals.
}
\examples{

library(btergm)
set.seed(1)

# Create 10 random networks with 10 actors

networks <- list()

for (i in 1:10) {
  mat <- matrix(rbinom(100, 1, .25), nrow = 10, ncol = 10)
  diag(mat) <- 0
  nw <- network::network(mat)
  networks[[i]] <- nw
}

# Create 10 matrices as covariates

covariates <- list()

for (i in 1:10) {
  mat <- matrix(rnorm(100), nrow = 10, ncol = 10)
  covariates[[i]] <- mat
}

# Fit a model where the propensity to form ties depends
# on the edge covariates, controlling for the number of
# in-stars
btfit <- btergm(networks ~ edges + istar(2) + edgecov(covariates), R = 100)

# Show terms, coefficient estimates and errors
tidy(btfit)

# Show coefficients as odds ratios with a 99\% CI
tidy(btfit, exponentiate = TRUE, conf.level = 0.99)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[btergm:btergm]{btergm::btergm()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{term}{The name of the regression term.}

}
