% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multcomp-tidiers.R
\name{tidy.cld}
\alias{tidy.cld}
\title{Tidy a(n) cld object}
\usage{
\method{tidy}{cld}(x, ...)
}
\arguments{
\item{x}{A \code{cld} object created by calling \code{\link[multcomp:cld]{multcomp::cld()}} on a
\code{glht}, \code{confint.glht()} or \code{summary.glht()} object.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(multcomp)
library(ggplot2)

amod <- aov(breaks ~ wool + tension, data = warpbreaks)
wht <- glht(amod, linfct = mcp(tension = "Tukey"))

tidy(wht)
ggplot(wht, aes(lhs, estimate)) +
  geom_point()

CI <- confint(wht)
tidy(CI)
ggplot(CI, aes(lhs, estimate, ymin = lwr, ymax = upr)) +
  geom_pointrange()

tidy(summary(wht))
ggplot(mapping = aes(lhs, estimate)) +
  geom_linerange(aes(ymin = lwr, ymax = upr), data = CI) +
  geom_point(aes(size = p), data = summary(wht)) +
  scale_size(trans = "reverse")

cld <- cld(wht)
tidy(cld)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[multcomp:cld]{multcomp::cld()}}, \code{\link[multcomp:methods]{multcomp::summary.glht()}},
\code{\link[multcomp:methods]{multcomp::confint.glht()}}, \code{\link[multcomp:glht]{multcomp::glht()}}

Other multcomp tidiers: 
\code{\link{tidy.confint.glht}()},
\code{\link{tidy.glht}()},
\code{\link{tidy.summary.glht}()}
}
\concept{multcomp tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{contrast}{Levels being compared.}
  \item{letters}{Compact letter display denoting all pair-wise comparisons.}

}
