% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-polr-tidiers.R
\name{tidy.polr}
\alias{tidy.polr}
\alias{polr_tidiers}
\title{Tidy a(n) polr object}
\usage{
\method{tidy}{polr}(
  x,
  conf.int = FALSE,
  conf.level = 0.95,
  exponentiate = FALSE,
  p.values = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{polr} object returned from \code{\link[MASS:polr]{MASS::polr()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{exponentiate}{Logical indicating whether or not to exponentiate the
the coefficient estimates. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults
to \code{FALSE}.}

\item{p.values}{Logical. Should p-values be returned,
based on chi-squared tests from \code{\link[MASS:dropterm]{MASS::dropterm()}}. Defaults to FALSE.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
In \verb{broom 0.7.0} the \code{coefficient_type} column was renamed to
\code{coef.type}, and the contents were changed as well. Now the contents
are \code{coefficient} and \code{scale}, rather than \code{coefficient} and \code{zeta}.

Calculating p.values with the \code{dropterm()} function is the approach
suggested by the MASS package author. This
approach is computationally intensive so that p.values are only
returned if requested explicitly. Additionally, it only works for
models containing no variables with more than two categories. If this
condition is not met, a message is shown and NA is returned instead of
p-values.
}
\examples{

# feel free to ignore the following line—it allows {broom} to supply 
# examples without requiring the model-supplying package to be installed.
if (requireNamespace("MASS", quietly = TRUE)) {

# load libraries for models and data
library(MASS)

# fit model
fit <- polr(Sat ~ Infl + Type + Cont, weights = Freq, data = housing)

# summarize model fit with tidiers
tidy(fit, exponentiate = TRUE, conf.int = TRUE)

glance(fit)
augment(fit, type.predict = "class")

fit2 <- polr(factor(gear) ~ am + mpg + qsec, data = mtcars)

tidy(fit, p.values = TRUE)

}

}
\seealso{
\link{tidy}, \code{\link[MASS:polr]{MASS::polr()}}

Other ordinal tidiers: 
\code{\link{augment.clm}()},
\code{\link{augment.polr}()},
\code{\link{glance.clmm}()},
\code{\link{glance.clm}()},
\code{\link{glance.polr}()},
\code{\link{glance.svyolr}()},
\code{\link{tidy.clmm}()},
\code{\link{tidy.clm}()},
\code{\link{tidy.svyolr}()}
}
\concept{ordinal tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
