% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictive_posterior.R
\name{Post_y}
\alias{Post_y}
\alias{dpost_y}
\alias{ppost_y}
\alias{qpost_y}
\alias{rpost_y}
\alias{spost_y}
\title{Posterior predictive distribution of the count in the control group}
\usage{
dpost_y(ynew, Tnew, a = 0.5, b = 0, c = 0.5, d = 0, x, y, T)

ppost_y(q, Tnew, a = 0.5, b = 0, c = 0.5, d = 0, x, y, T)

qpost_y(p, Tnew, a = 0.5, b = 0, c = 0.5, d = 0, x, y, T)

rpost_y(n, Tnew, a = 0.5, b = 0, c = 0.5, d = 0, x, y, T)

spost_y(Tnew, a = 0.5, b = 0, c = 0.5, d = 0, x, y, T, ...)
}
\arguments{
\item{ynew,q}{vector of non-negative \strong{integer} quantiles}

\item{a,b}{non-negative shape parameter and rate parameter of the Gamma prior distribution on the rate \eqn{\mu}}

\item{c,d}{non-negative shape parameters of the prior distribution on \eqn{\phi}}

\item{x,y}{counts (integer) in the treated group and control group of the observed experiment}

\item{T,Tnew}{sample sizes of the control group in the observed experiment and the
predicted experiment}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}

\item{...}{arguments passed to \code{\link{summary_PGIB}}}
}
\value{
\code{dpost_y} gives the density, \code{ppost_y} the distribution function,
\code{qpost_y} the quantile function, \code{rpost_y} samples from the distribution,
and \code{spost_y} gives a summary of the distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the posterior predictive distribution of the count in the control group.










}
\details{
The posterior predictive distribution of the count in the treated group is a
\code{\link[=PGIBDist]{Poisson-Gamma-Inverse Beta distribution}}.
}
\note{
\code{Post_y} is a generic name for the functions documented.
}
\examples{
barplot(dpost_y(0:10, 10, 2, 7, 3, 4, 5, 3, 10))
spost_y(10, 2, 7, 3, 4, 5, 3, 10, output="pandoc")
}

