% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/posteriors.R
\name{Posterior_lambda}
\alias{Posterior_lambda}
\alias{dpost_lambda}
\alias{rpost_lambda}
\alias{spost_lambda}
\title{Posterior distribution on the incidence rate in the treated group}
\usage{
dpost_lambda(lambda, a, c, d, S, x, y, ...)

rpost_lambda(n, a, c, d, S, x, y)

spost_lambda(a, c, d, S, x, y, ...)
}
\arguments{
\item{lambda}{vector of quantiles}

\item{a}{non-negative shape parameter of the Gamma prior distribution on \eqn{\mu}}

\item{c,d}{non-negative shape parameters of the prior distribution on \eqn{\phi}}

\item{S}{sample size in treated group}

\item{x,y}{counts in the treated group and control group}

\item{...}{other arguments passed to \code{\link{GIBDist}}}

\item{n}{number of observations to be simulated}
}
\value{
\code{dpost_lambda} gives the density, and \code{rpost_lambda} samples from
the distribution, and \code{spost_lambda} gives a summary of the distribution.
}
\description{
Density and random generation for the posterior distribution on
the rate in the treated group. The distribution function and the quantile function
are not available.






}
\details{
The pdf of the posterior distribution of the incidence rate \eqn{\lambda} involves
the Kummer confluent hypergeometric function of the second kind.
}
\note{
\code{Posterior_lambda} is a generic name for the functions documented.
}
\examples{
curve(dpost_lambda(x, 2, 2, 2, 20, 1, 10), from=0, to=0.4)
spost_lambda(2, 2, 2, 20, 1, 10)
}

