% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{brulee-autoplot}
\alias{brulee-autoplot}
\alias{autoplot.brulee_mlp}
\alias{autoplot.brulee_logistic_reg}
\alias{autoplot.brulee_multinomial_reg}
\alias{autoplot.brulee_linear_reg}
\title{Plot model loss over epochs}
\usage{
\method{autoplot}{brulee_mlp}(object, ...)

\method{autoplot}{brulee_logistic_reg}(object, ...)

\method{autoplot}{brulee_multinomial_reg}(object, ...)

\method{autoplot}{brulee_linear_reg}(object, ...)
}
\arguments{
\item{object}{A \code{brulee_mlp}, \code{brulee_logistic_reg},
\code{brulee_multinomial_reg}, or \code{brulee_linear_reg} object.}

\item{...}{Not currently used}
}
\value{
A \code{ggplot} object.
}
\description{
Plot model loss over epochs
}
\details{
This function plots the loss function across the available epochs. A
vertical line shows the epoch with the best loss value.
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
 library(ggplot2)
 library(recipes)
 theme_set(theme_bw())

 data(ames, package = "modeldata")

 ames$Sale_Price <- log10(ames$Sale_Price)

 set.seed(1)
 in_train <- sample(1:nrow(ames), 2000)
 ames_train <- ames[ in_train,]
 ames_test  <- ames[-in_train,]

 ames_rec <-
  recipe(Sale_Price ~ Longitude + Latitude, data = ames_train) \%>\%
    step_normalize(all_numeric_predictors())

 set.seed(2)
 fit <- brulee_mlp(ames_rec, data = ames_train, epochs = 50, batch_size = 32)

 autoplot(fit)
}
}
}
