% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{cardPad}
\alias{cardPad}
\title{AdminLTE3 vertical block container}
\usage{
cardPad(..., color = NULL, style = NULL)
}
\arguments{
\item{...}{Any element such as \link{descriptionBlock}.}

\item{color}{Background color: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{style}{Custom CSS, if any.}
}
\description{
Create a vertical container for \link{descriptionBlock} or other elements
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 shinyApp(
  ui = bs4DashPage(
    bs4DashNavbar(),
    bs4DashSidebar(),
    bs4DashControlbar(),
    bs4DashBody(
     bs4Card(
      title = "Box with right pad",
      status = "warning",
      fluidRow(
        column(width = 6),
        column(
          width = 6,
          cardPad(
            color = "info",
            descriptionBlock(
              header = "8390", 
              text = "VISITS", 
              right_border = FALSE,
              margin_bottom = TRUE
            ),
            descriptionBlock(
              header = "30\%", 
              text = "REFERRALS", 
              right_border = FALSE,
              margin_bottom = TRUE
            ),
            descriptionBlock(
              header = "70\%", 
              text = "ORGANIC", 
              right_border = FALSE,
              margin_bottom = FALSE
            )
          )
        )
      )
     )
    ),
    title = "cardPad"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
