% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardSidebar.R, R/aliases.R
\name{bs4SidebarMenuSubItem}
\alias{bs4SidebarMenuSubItem}
\alias{menuSubItem}
\title{Create a Boostrap 4 dashboard main sidebar menu sub-item}
\usage{
bs4SidebarMenuSubItem(text, tabName = NULL, icon = NULL)

menuSubItem(text, tabName = NULL, icon = NULL)
}
\arguments{
\item{text}{Item name.}

\item{tabName}{Should correspond exactly to the tabName given in \code{\link{bs4TabItem}}.}

\item{icon}{Item icon.}
}
\description{
Build an adminLTE3 dashboard main sidebar menu sub-item
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(
       bs4SidebarMenu(
         bs4SidebarHeader("List of items 1"),
         bs4SidebarMenuItem(
           text = "Item List",
           icon = "bars",
           startExpanded = TRUE,
           bs4SidebarMenuSubItem(
             text = "Item 1",
             tabName = "item1",
             icon = "circle-thin"
           ),
           bs4SidebarMenuSubItem(
             text = "Item 2",
             tabName = "item2",
             icon = "circle-thin"
           )
         ),
         bs4SidebarHeader("Classic Items"),
         bs4SidebarMenuItem(
           text = "Item 3",
           tabName = "item3"
         ),
         bs4SidebarHeader("List of items 2"),
         bs4SidebarMenuItem(
           text = "Item List 2",
           icon = "bars",
           startExpanded = FALSE,
           #active = FALSE,
           bs4SidebarMenuSubItem(
             text = "Item 4",
             tabName = "item4",
             icon = "circle-thin"
           ),
           bs4SidebarMenuSubItem(
             text = "Item 5",
             tabName = "item5",
             icon = "circle-thin"
           )
         )
       )
     ),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
       bs4TabItems(
         bs4TabItem(
           tabName = "item1",
           bs4Card(
             title = "Card 1", 
             closable = TRUE, 
             width = 6,
             solidHeader = TRUE, 
             status = "primary",
             collapsible = TRUE,
             p("Box Content")
           )
         ),
         bs4TabItem(
           tabName = "item2",
           bs4Card(
             title = "Card 2", 
             closable = TRUE, 
             width = 6,
             solidHeader = TRUE, 
             status = "warning",
             collapsible = TRUE,
             p("Box Content")
           )
         ),
         bs4TabItem(
           tabName = "item3",
           bs4Card(
             title = "Card 3", 
             closable = TRUE, 
             width = 6,
             solidHeader = TRUE, 
             status = "danger",
             collapsible = TRUE,
             p("Box Content")
           )
         ),
         bs4TabItem(
           tabName = "item4",
           bs4Card(
             title = "Card 4", 
             closable = TRUE, 
             width = 6,
             solidHeader = TRUE, 
             status = "info",
             collapsible = TRUE,
             p("Box Content")
           )
         ),
         bs4TabItem(
           tabName = "item5",
           bs4Card(
             title = "Card 5", 
             closable = TRUE, 
             width = 6,
             solidHeader = TRUE, 
             status = "success",
             collapsible = TRUE,
             p("Box Content")
           )
         )
       )
     )
   ),
   server = function(input, output) {}
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
