% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{compute_fitted_values.PosteriorBSVARSIGN}
\alias{compute_fitted_values.PosteriorBSVARSIGN}
\title{Computes posterior draws from data predictive density}
\usage{
\method{compute_fitted_values}{PosteriorBSVARSIGN}(posterior)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARSIGN} obtained by running the \code{estimate} function.}
}
\value{
An object of class \code{PosteriorFitted}, that is, an \code{NxTxS} 
array with attribute \code{PosteriorFitted} containing \code{S} draws from 
the data predictive density.
}
\description{
Each of the draws from the posterior estimation of models from 
packages \pkg{bsvars} or \pkg{bsvarSIGNs} is transformed into
a draw from the data predictive density.
}
\examples{
# upload data
data(optimism)

# specify the model and set seed
set.seed(123)

# + no effect on productivity (zero restriction)
# + positive effect on stock prices (positive sign restriction) 
sign_irf       = matrix(c(0, 1, rep(NA, 23)), 5, 5)
specification  = specify_bsvarSIGN$new(optimism, sign_irf = sign_irf)

# estimate the model
posterior      = estimate(specification, 10)

# compute draws from in-sample predictive density
fitted         = compute_fitted_values(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
optimism |>
  specify_bsvarSIGN$new(sign_irf = sign_irf) |> 
  estimate(S = 20) |> 
  compute_fitted_values() -> fitted

}
\seealso{
\code{\link{estimate.BSVARSIGN}}, \code{\link{summary}}, \code{\link{plot}}
}
\author{
Xiaolei Wang \email{adamwang15@gmail.com} and Tomasz Woźniak \email{wozniak.tom@pm.me}
}
