% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorIR}
\alias{summary.PosteriorIR}
\title{Provides posterior summary of impulse responses}
\usage{
\method{summary}{PosteriorIR}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorIR obtained using the
\code{compute_impulse_responses()} function containing draws from the posterior
distribution of the impulse responses.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 
5 and 95 percentiles of the impulse responses of each variable to each of the 
shocks at all horizons.
}
\description{
Provides posterior summary of the impulse responses of each 
variable to each of the shocks at all horizons. Includes their posterior 
means, standard deviations, as well as 5 and 95 percentiles.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20, thin = 1)

# compute impulse responses
irf            = compute_impulse_responses(posterior, horizon = 4)
irf_summary    = summary(irf)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new() |>
  estimate(S = 10) |> 
  estimate(S = 20, thin = 1) |> 
  compute_impulse_responses(horizon = 4) |>
  summary() -> irf_summary

}
\seealso{
\code{\link{compute_impulse_responses}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
