% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorRegimePr}
\alias{summary.PosteriorRegimePr}
\title{Provides posterior summary of regime probabilities}
\usage{
\method{summary}{PosteriorRegimePr}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorRegimePr obtained using the
\code{compute_regime_probabilities()} function containing posterior draws of 
regime allocations.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean and standard deviations of the
regime probabilities.
}
\description{
Provides posterior summary of regime probabilities 
including their mean, standard deviations, as well as 5 and 95 percentiles.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_msh$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# compute regime probabilities
rp             = compute_regime_probabilities(posterior)
rp_summary     = summary(rp)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_msh$new() |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  compute_regime_probabilities() |>
  summary() -> rp_summary

}
\seealso{
\code{\link{compute_regime_probabilities}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
