% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiPlotInput.R
\name{multiPlotInput}
\alias{multiPlotInput}
\title{Arrange bubbleHeatmap Arguments in Lists for Building Multiple Plots.}
\usage{
multiPlotInput(
  colorList,
  sizeList = colorList,
  nightingale = TRUE,
  treeNames = names(colorList),
  context = gpar(cex = 0.8),
  colorSeq = c("#053061", "#2166AC", "#4393C3", "#92C5DE", "#D1E5F0", "#FDDBC7",
    "#F4A582", "#D6604D", "#B2182B", "#67001F"),
  unitBase = unit(0.5, "cm"),
  diameter = 0.8,
  colorLim = c(NA, NA),
  sizeLim = c(NA, NA),
  showTopLabels = TRUE,
  showLeftLabels = TRUE,
  leftLabelsTitles = FALSE,
  showRowBracket = FALSE,
  rowTitles = FALSE,
  showColBracket = FALSE,
  colTitles = FALSE,
  plotTitles = FALSE,
  xTitles = FALSE,
  yTitles = FALSE,
  showColorLegend = TRUE,
  showBubbleLegend = TRUE,
  colorBreaks = NULL,
  sizeBreaks = NULL,
  legendHeight = nrow(colorList[[1]]),
  legendTitles = c(expression("-log"[10] * "P"), "Estimate (SD)")
)
}
\arguments{
\item{colorList, sizeList}{List of matrices, each item representing one plot,
containing values to be plotted as the bubble color and size respectively. If
\code{sizeList} is not supplied then color values will also be used for size.}

\item{nightingale}{Logical, apply Nightingale style template?}

\item{treeNames}{Vector of names for gTrees output by bubbleHeatmap, if not
supplied then \code{names(colorList)} will be used.}

\item{context}{\code{\link[grid]{gpar}} object to provide drawing context.
Will be applied to the parent viewport in the childrenvp slot of gTrees
output by bubbleHeatmap.}

\item{colorSeq}{Vector of colors to distribute over color scale gradient.}

\item{unitBase}{\code{\link[grid]{unit}} object indicating the size of one
plot grid square.}

\item{diameter}{Maximum diameter of bubbles as multiple of unitBase.}

\item{colorLim, sizeLim}{Numeric vectors indicating limits (min/max) beyond
which the values of color/size matrices should be truncated.}

\item{showTopLabels}{Logical vector, should matrix column names be printed
above each plot? Should have \code{length == length(colorList)} or
\code{length == 1} to use same value for all plots.}

\item{showLeftLabels}{Logical vector, should matrix row names be printed
above each plot? Should have \code{length == length(colorList)} or
\code{length == 1} to use same value for all plots.}

\item{leftLabelsTitles}{Vector of headings to go over the row names of each
plot. Character strings or FALSE for no title. A single FALSE value can also
be used if no left label titles are required.}

\item{showRowBracket}{Logical vector, should vertical bracket be printed to
the right of each plot (to label a row of plots in a final figure layout)?
Should have \code{length == length(colorList)} or \code{length == 1} to use
same value for all plots.}

\item{rowTitles}{Vector of labels to be printed to the right of each plot,
outside row bracket if present (to label a row of plots in a final figure
layout). Character strings or FALSE for no title. A single FALSE value
can also be used if no row titles are required.}

\item{showColBracket}{Logical vector, should horizontal bracket be printed
below each plot (to label a column of plots in a final figure layout)?
Should have \code{length == length(colorList)} or \code{length == 1} to use
same value for all plots.}

\item{colTitles}{Vector of labels to be printed to the right of each plot,
outside col bracket if present (to label a column of plots in a final figure
layout). Character strings or FALSE for no title. A single FALSE value can
also be used if no column titles are required.}

\item{plotTitles}{Vector of plot titles to be centered above each plot.
Character strings or FALSE for no title. A single FALSE value can also be
used if no plot titles are required.}

\item{xTitles}{Vector of x axis titles to be printed left of
\code{LeftLabels}. Character strings or FALSE for no title. A single FALSE
value can also be used if no x axis titles are required.}

\item{yTitles}{Vector of y axis titles to be printed above \code{TopLabels}.
Character strings or FALSE for no title. A single FALSE value can also be
used if no y axis titles are required.}

\item{showColorLegend, showBubbleLegend}{Logicals, should a legend be produced
for color scale/bubble size? If vector with \code{length == length(colorList)}
then values will be input for each plot and any legends produced will be an
element of a plot tree. A single TRUE value will build the legends outside
the plots as separate trees.}

\item{colorBreaks, sizeBreaks}{Character vectors of legend tick labels. If not
supplied then these will be generated using pretty to a range outside data
values (after values truncated to \code{colorLim}\\\code{sizeLim} if
applicable).}

\item{legendHeight}{Numeric, preferred height of legends as multiple of
\code{unitBase}. This will be supplied to pretty function. If {sizeBreaks} is
supplied then this will be ignored and legend height will be
\code{length(sizeBreaks)}.}

\item{legendTitles}{Character vector of legend titles. First string should be
the size legend title, second for the color legend.}
}
\value{
List with two elements:
\describe{
\item{trees}{List of lists, arguments for \code{bubbleHeatmap}}
\item{legend}{List of arguments for \code{bubbleHMLegends}}}
The list returned by this plot can be passed directly to
\code{\link{bubbleHeatmapList}} to produce a list of plot trees.
}
\description{
Build bubbleHeatmap arguments into a list of lists to facilitate building of
multiple plots in a single call. It is useful for creating sets of plots with
the same data scales, similar plots with minor differences in settings, or
the supplied Nightingale plot template.
}
\section{Nightingale}{

For more information about using the Nightingale style template, see the
vignette. Requesting Nightingale style values overrides any argument for
plotTitles, xTitles, yTitles, showTopLabels, showLeftLabels,
leftLabelsTitles, showRowBracket, rowTitles, showColBracket, colTitles,
showBubbleLegend or showColorLegend.
}

\seealso{
Other build functions: 
\code{\link{bubbleHMLegends}()},
\code{\link{bubbleHeatmapList}()},
\code{\link{bubbleHeatmap}()}
}
\concept{build functions}
