% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildlme}
\alias{buildlme}
\title{Use buildmer to perform stepwise elimination of the fixed-effects part of mixed-effects models fit via lme() from nlme}
\usage{
buildlme(formula, data = NULL, random, cl = NULL,
  direction = c("order", "backward"), crit = "LRT", include = NULL,
  calc.anova = TRUE, calc.summary = TRUE, quiet = FALSE, ...)
}
\arguments{
\item{formula}{The model formula for the maximal model you would like to fit, if possible.}

\item{data}{The data to fit the models to.}

\item{random}{The random-effects specification for the model. This is not manipulated by buildlme() in any way!}

\item{cl}{An optional cluster object as returned by function \code{makeCluster()} from package \code{parallel} to use for parallelizing the evaluation of terms.}

\item{direction}{Character string or vector indicating the direction for stepwise elimination; possible options are \code{'order'} (order terms by their contribution to the model), \code{'backward'} (backward elimination), \code{'forward'} (forward elimination, implies \code{order}). The default is the combination \code{c('order','backward')}, to first make sure that the model converges and to then perform backward elimination; other such combinations are perfectly allowed.}

\item{crit}{Character string or vector determining the criterion used to test terms for elimination. Possible options are \code{'LRT'} (likelihood-ratio test; this is the default), \code{'LL'} (use the raw -2 log likelihood), \code{'AIC'} (Akaike Information Criterion), and \code{'BIC'} (Bayesian Information Criterion).}

\item{include}{A character vector of terms that will be kept in the model at all times. These do not need to be specified separately in the \code{formula} argument.}

\item{calc.anova}{Logical indicating whether to also calculate the ANOVA table for the final model after term elimination.}

\item{calc.summary}{Logical indicating whether to also calculate the summary table for the final model after term elimination.}

\item{quiet}{Logical indicating whether to suppress progress messages.}

\item{...}{Additional options to be passed to \code{lme()}.}
}
\description{
Use buildmer to perform stepwise elimination of the fixed-effects part of mixed-effects models fit via lme() from nlme
}
\examples{
library(buildmer)
m <- buildlme(Reaction ~ Days,data=lme4::sleepstudy,random=~Days|Subject)
}
\seealso{
\code{\link[=buildmer]{buildmer()}}
}
