% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRNfuns.R
\name{find_regulators_with_recurring_edges}
\alias{find_regulators_with_recurring_edges}
\title{Find recurring regulators}
\usage{
find_regulators_with_recurring_edges(weightMatList, plotConnections)
}
\arguments{
\item{weightMatList}{a list of (weighted) adjacency matrices;
each list element must be an adjacency matrix with regulators in rows,
targets in columns}

\item{plotConnections}{the number of connections to subset to}
}
\value{
A vector containing the names of the recurring regulators
}
\description{
This function finds regulators that appear as the
same network edge in more than one of the input networks.
}
\examples{
weightMat1 <- matrix(
  c(0.1, 0.4, 0.8, 0.3), nrow = 2, ncol = 2,
  dimnames = list("regulators" = c("r1", "r2"), "targets" = c("t1", "t2"))
)
weightMat2 <- matrix(
  c(0.1, 0.2, 0.8, 0.3), nrow = 2, ncol = 2,
  dimnames = list("regulators" = c("r1", "r2"), "targets" = c("t1", "t2"))
)
find_regulators_with_recurring_edges(list(weightMat1, weightMat2), 2)
}
