% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin_posterior.bvec.R
\name{thin_posterior.bvec}
\alias{thin_posterior.bvec}
\title{Thinning Posterior Draws}
\usage{
\method{thin_posterior}{bvec}(x, thin = 10)
}
\arguments{
\item{x}{an object of class \code{"bvec"}.}

\item{thin}{an integer specifying the thinning interval between successive values of posterior draws.}
}
\value{
An object of class \code{"bvec"}.
}
\description{
Thins the MCMC posterior draws in an object of class \code{"bvec"}.
}
\examples{

# Load data
data("e6")

# Generate model data
model <- gen_vec(e6, p = 2, r = 1,
                 const = "unrestricted", seasonal = "unrestricted",
                 iterations = 100, burnin = 10)

# Add prior specifications
model <- add_priors(model)

# Obtain posterior draws
object <- draw_posterior(model)

# Thin
object <- thin_posterior(object)

}
