% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{normTable}
\alias{normTable}
\title{Create a norm table based on model for specific age}
\usage{
normTable(A, model, minNorm = NULL, maxNorm = NULL, minRaw = NULL,
  maxRaw = NULL, step = 0.1, descend = NULL)
}
\arguments{
\item{A}{the age}

\item{model}{The regression model}

\item{minNorm}{The lower bound of the norm score range}

\item{maxNorm}{The upper bound of the norm score range}

\item{minRaw}{clipping parameter for the lower bound of raw scores}

\item{maxRaw}{clipping parameter for the upper bound of raw scores}

\item{step}{Stepping parameter with lower values indicating higher precision}

\item{descend}{Reverse raw value order. If set to TRUE, lower raw values
indicate higher performance. Relevant f. e. in case of modeling errors}
}
\value{
data.frame with norm scores and the predicted raw scores
}
\description{
This function generates a norm table for a specific age based on the regression
model by assigning raw scores to norm scores. Please specify the
range of norm scores, you want to cover. A T value of 25 corresponds to a percentile
of .6. As a consequence, specifying a rang of T = 25 to T = 75 would cover 98.4 % of
the population. Please be careful when extrapolating vertically (at the lower and
upper end of the age specific distribution). Depending on the size of your standardization
sample, extreme values with T < 20 or T > 80 might lead to inconsistent results.
}
\examples{
normData <- prepareData()
m <- bestModel(data=normData)
norms <- normTable(3.5, m, minNorm=25, maxNorm=75, step=0.5)
}
\seealso{
rawTable
}
