% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{betaByGroup}
\alias{betaByGroup}
\title{Estimate Beta-Binomial Parameters by Group}
\usage{
betaByGroup(x, group, n)
}
\arguments{
\item{x}{A vector of non-negative integers representing the number of successes in trials for the entire dataset.}

\item{group}{A factor or similar object that divides `x` into groups. Each element of `x` is associated
with a group indicated by the corresponding element in `group`.}

\item{n}{The maximum number of trials, assumed to be the same for all groups.}
}
\value{
A data frame where each row contains the beta-binomial distribution parameters (alpha `a`, beta `b`,
mean `m`, variance `var`) for a group, along with the group identifier. The columns are named `a`, `b`, `m`,
`var`, `n`, and `group`, with each row corresponding to a distinct group in the input.
}
\description{
This function calculates the beta-binomial distribution parameters (alpha, beta, mean, variance)
for subsets of data grouped by a specified factor. It applies the `betaCoefficients` function
to each group separately, aggregating the results into a single data frame. This is particularly
useful for analyzing heterogeneity in success probabilities across different groups within a dataset.
}
\details{
The function first identifies unique groups in the `group` argument and then iterates over these groups.
For each group, it extracts the subset of `x` corresponding to that group and computes the beta-binomial
distribution parameters using the `betaCoefficients` function. The results are compiled into a matrix that is
then converted into a data frame for easier manipulation and interpretation.
}
\examples{
x <- elfe$raw
group <- elfe$group
n <- 26
betaByGroup(x, group, n)
}
