% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotDensity}
\alias{plotDensity}
\title{Plot the density function per group by raw score}
\usage{
plotDensity(
  model,
  minRaw = NULL,
  maxRaw = NULL,
  minNorm = NULL,
  maxNorm = NULL,
  group = NULL
)
}
\arguments{
\item{model}{The model from the bestModel function, a cnorm object, or a cnormBetaBinomial or cnormBetaBinomial2 object.}

\item{minRaw}{Lower bound of the raw score. If NULL, it's automatically determined based on the model type.}

\item{maxRaw}{Upper bound of the raw score. If NULL, it's automatically determined based on the model type.}

\item{minNorm}{Lower bound of the norm score. If NULL, it's automatically determined based on the model type.}

\item{maxNorm}{Upper bound of the norm score. If NULL, it's automatically determined based on the model type.}

\item{group}{Numeric vector specifying the age groups to plot. If NULL, groups are automatically selected.}
}
\value{
A ggplot object representing the density functions.
}
\description{
This function plots density curves based on the regression model against the raw scores.
It supports both traditional continuous norming models and beta-binomial models.
The function allows for customization of the plot range and groups to be displayed.
}
\details{
The function generates density curves for specified age groups, allowing for easy comparison of score distributions
across different ages.

For beta-binomial models, the density is based on the probability mass function, while for
traditional models, it uses a normal distribution based on the norm scores.
}
\note{
Please check for inconsistent curves, especially those showing implausible shapes
such as violations of biuniqueness in the cnorm models.
}
\examples{
\dontrun{
# For traditional continuous norming model
result <- cnorm(raw = elfe$raw, group = elfe$group)
plotDensity(result, group = c(2, 4, 6))

# For beta-binomial model
bb_model <- cnorm.betabinomial(age = ppvt$age, score = ppvt$raw, n = 228)
plotDensity(bb_model)
}

}
\seealso{
\code{\link{plotNormCurves}}, \code{\link{plotPercentiles}}

Other plot: 
\code{\link{compare}()},
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDerivative}()},
\code{\link{plotNorm}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
