% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateVIFModeB}
\alias{calculateVIFModeB}
\title{Internal: Calculate variance inflation factors (VIF) for weights obtained by PLS Mode B}
\usage{
calculateVIFModeB(.object = NULL)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}
}
\value{
A named list of vectors containing the VIF values. Each list name
is the name of a construct whose weights were obtained by Mode B.
The vectors contain the VIF values obtained from a regression of each
explanatory variable of a given construct on the remaining explanatory
variables of that construct.

If the weighting approach is not \code{"PLS-PM"} or for none of the constructs Mode B is used,
the function silently returns \code{NA}.
}
\description{
Calculate the variance inflation factor (VIF) for weights obtained by PLS-PM's Mode B.
}
\details{
Weight estimates obtained by Mode B can suffer from multicollinearity. VIF values
are commonly used to assess the severity of multicollinearity.

The function is only applicable to objects of class \code{cSEMResults_default}.
For other object classes use \code{\link[=assess]{assess()}}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
\keyword{internal}
