% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_estimators_paths.R
\name{moments}
\alias{moments}
\alias{SingleSingle}
\alias{SingleQuadratic}
\alias{SingleCubic}
\alias{SingleTwInter}
\alias{SingleThrwInter}
\alias{SingleQuadTwInter}
\alias{QuadraticQuadratic}
\alias{QuadraticCubic}
\alias{QuadraticTwInter}
\alias{QuadraticThrwInter}
\alias{QuadraticQuadTwInter}
\alias{CubicCubic}
\alias{CubicTwInter}
\alias{CubicThrwInter}
\alias{CubicQuadTwInter}
\alias{TwInterTwInter}
\alias{TwInterThrwInter}
\alias{TwInterQuadTwInter}
\alias{ThrwInterThrwInter}
\alias{ThrwInterQuadTwInter}
\alias{QuadTwInercQuadTwInter}
\title{Internal: Calculate consistent moments of a nonlinear model}
\usage{
SingleSingle(.i, .j, .Q, .H)

SingleQuadratic(.i, .j, .Q, .H)

SingleCubic(.i, .j, .Q, .H)

SingleTwInter(.i, .j, .Q, .H)

SingleThrwInter(.i, .j, .Q, .H)

SingleQuadTwInter(.i, .j, .Q, .H)

QuadraticQuadratic(.i, .j, .Q, .H)

QuadraticCubic(.i, .j, .Q, .H)

QuadraticTwInter(.i, .j, .Q, .H)

QuadraticThrwInter(.i, .j, .Q, .H)

QuadraticQuadTwInter(.i, .j, .Q, .H)

CubicCubic(.i, .j, .Q, .H)

CubicTwInter(.i, .j, .Q, .H)

CubicThrwInter(.i, .j, .Q, .H)

CubicQuadTwInter(.i, .j, .Q, .H)

TwInterTwInter(.i, .j, .Q, .H)

TwInterThrwInter(.i, .j, .Q, .H)

TwInterQuadTwInter(.i, .j, .Q, .H)

ThrwInterThrwInter(.i, .j, .Q, .H)

ThrwInterQuadTwInter(.i, .j, .Q, .H)

QuadTwInercQuadTwInter(.i, .j, .Q, .H)
}
\arguments{
\item{.i}{Row index}

\item{.j}{Column index}

\item{.Q}{A vector of composite-construct correlations with element names equal to
the names of the J construct names used in the measurement model. Note
Q^2 is also called the reliability coefficient.}

\item{.H}{The (N x J) matrix of construct scores.}
}
\description{
Collection of various moment estimators. See \link{classifyConstructs} for a list of
possible moments.
}
\details{
M is the matrix of the sample counterparts (estimates) of the
left-hand side terms in Equation (21) - (24) \insertCite{Dijkstra2014}{cSEM}.
The label "M" did not appear in the paper and is only used in the package.
Similar is suggested by \insertCite{Wall2000;textual}{cSEM} using classical factor scores.
}
\keyword{internal}
