\name{final.table}
\alias{final.table}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
CaRpools: Generating Table with Analysis Information from all Methods
}
\description{
CaRpools also provides you with a final gene table, which includes p-values, fold changes and ranks by all methods in a single tabular output.  
This output is **unbiased** and can thus be used for further analysis and data visualization.  
It takes the output generated by each analysis method, `stat.wilcox`, `stat.DEseq` and `stat.mageck` and combines it into a single tabular representation.  
}
\usage{
final.table(wilcox=NULL, deseq=NULL, mageck=NULL, dataset, namecolumn=1,
norm.function=median, type="genes", extractpattern = expression("^(.+?)_.+"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{

\item{wilcox}{
Data output from `stat.wilcox`.  
*Default* NULL  
*Values* Data output from `stat.wilcox`.  
}
\item{deseq}{
Data output from `stat.deseq`.  
*Default* NULL  
*Values* Data output from `stat.deseq`.  
}
\item{mageck}{
Data output from `stat.mageck`.  
*Default* NULL  
*Values* Data output from `stat.mageck`.  
}
\item{dataset}{
data.frame as created by `load.file`  
*Default* empty  
*Values* data frame  
}
\item{namecolumn}{
In which column are the sgRNA identifiers?  
*Default* 1  
*Values* column number (numeric)  
}
\item{extractpattern}{
PERL regular expression that is used to retrieve the gene identifier from the overall sgRNA identifier.  
e.g. in **AAK1_107_0** it will extract **AAK1**, since this is the gene identifier beloning to this sgRNA identifier. **Please see: Read-Count Data Files**  
*Default* expression("^(.+?)(_.+)"), will work for most available libraries.  
*Values* PERL regular expression with parenthesis indicating the gene identifier (expression)  
}
\item{norm.function}{
The mathematical function to normalize data if `normalize=TRUE`. By default, the median is used.  
*Default* median  
*Values* Any mathematical function of R (function)  
}
\item{type}{
Output generated.  
*Default* "genes"  
*Values* "genes"
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
none
}
\value{
Returns a data.frame of gene names and all information generated by stat.wilcox, stat.DEseq and stat.mageck.
}

\author{
Jan Winter
}
\note{
%%  ~~further notes~~
none
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
data(caRpools)
data.wilcox = stat.wilcox(untreated.list = list(CONTROL1, CONTROL2),
  treated.list = list(TREAT1,TREAT2), namecolumn=1, fullmatchcolumn=2,
  normalize=TRUE, norm.fun=median, sorting=FALSE, controls="random",
  control.picks=NULL)
  
data.deseq = stat.DESeq(untreated.list = list(CONTROL1, CONTROL2),
  treated.list = list(TREAT1,TREAT2), namecolumn=1,
  fullmatchcolumn=2, extractpattern=expression("^(.+?)(_.+)"),
  sorting=FALSE, filename.deseq = "ANALYSIS-DESeq2-sgRNA.tab",
  fitType="parametric")
  
data.mageck = stat.mageck(untreated.list = list(CONTROL1, CONTROL2),
treated.list = list(TREAT1,TREAT2), namecolumn=1, fullmatchcolumn=2,
norm.fun="median", extractpattern=expression("^(.+?)(_.+)"), mageckfolder=NULL,
sort.criteria="neg", adjust.method="fdr", filename = "TEST" , fdr.pval = 0.05)

final.tab = final.table(wilcox=data.wilcox, deseq=data.deseq,
mageck=data.mageck, dataset=CONTROL1.g, namecolumn=1, type="genes")
knitr::kable(final.tab[1:20,])
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~Output }% __ONLY ONE__ keyword per line
