% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineclassesandfunctions.R
\docType{class}
\name{cabootcrsresults-class}
\alias{cabootcrsresults-class}
\title{A class containing the results from CA with bootstrapping}
\description{
This contains all of the usual output from simple or multiple CA,
plus the results of the bootstrap analysis and the various settings used for this.
}
\details{
The meanings and possible values for the settings are described in \code{\link{cabootcrs}}
}
\section{Slots}{

\describe{
\item{\code{br}}{The basic results from CA, class \code{\linkS4class{cabasicresults}}}

\item{\code{DataMatrix}}{The sample data matrix, class \code{"matrix"}}

\item{\code{rows}}{Number of rows, class \code{"numeric"}}

\item{\code{columns}}{Number of columns, class \code{"numeric"}}

\item{\code{rowlabels}}{Row category labels, class \code{"character"}}

\item{\code{collabels}}{Column category labels, class \code{"character"}}

\item{\code{varnames}}{Names of the variables, class \code{"character"}}

\item{\code{Rowprinccoord}}{Principal coordinates for row points, class \code{"matrix"}}

\item{\code{Colprinccoord}}{Principal coordinates for column points, class \code{"matrix"}}

\item{\code{Rowstdcoord}}{Standard coordinates for row points, class \code{"matrix"}}

\item{\code{Colstdcoord}}{Standard coordinates for column points, class \code{"matrix"}}

\item{\code{RowCTR}}{Contributions for row points, class \code{"matrix"}}

\item{\code{RowREP}}{Representations for row points, class \code{"matrix"}}

\item{\code{ColCTR}}{Contributions for column points, class \code{"matrix"}}

\item{\code{ColREP}}{Representations for column points, class \code{"matrix"}}

\item{\code{RowVar}}{Variances for row points, class \code{"matrix"}}

\item{\code{RowCov}}{Covariances for row points, class \code{"array"}}

\item{\code{ColVar}}{Variances for column points, class \code{"matrix"}}

\item{\code{ColCov}}{Covariances for column points, class \code{"array"}}

\item{\code{inertiasum}}{Total inertia, class \code{"numeric"}}

\item{\code{inertias}}{Axis inertias, class \code{"matrix"}}

\item{\code{nboots}}{Number of bootstrap replicates used to calculate the (co)variances, class \code{"numeric"}. \cr
If nboots=0 then standard CA or MCA is performed with no confidence regions produced.}

\item{\code{resampledistn}}{Distribution used for resampling, class \code{"character"}}

\item{\code{multinomialtype}}{Form of multinomial resampling used, class \code{"character"}}

\item{\code{sameaxisorder}}{Number of resamples with no reordering in first six bootstrap axes, class \code{"numeric"}}

\item{\code{poissonzeronewmean}}{Mean used for resampling zero cells, class \code{"numeric"}}

\item{\code{newzeroreset}}{Option to reset resample zero cells, class \code{"numeric"}}

\item{\code{printdims}}{Number of dimensions to print, though note that all are stored, class \code{"numeric"}}

\item{\code{axisvariances}}{Number of axes for which variances were calculated and are stored, class \code{"numeric"}}

\item{\code{bootcritR}}{Bootstrap critical values for row points, class \code{"array"}}

\item{\code{bootcritC}}{Bootstrap critical values for column points, class \code{"array"}}

\item{\code{usebootcrits}}{Whether to use bootstrap critical values for confidence ellipses, class \code{"logical"}}

\item{\code{catype}}{Type of correspondence analysis performed, class \code{"character"}}

\item{\code{mcatype}}{Type of multiple correspondence analysis performed, class \code{"character"}}

\item{\code{mcaindividualboot}}{Whether the experimental method to bootstrap an indicator or doubled matrix was used, class \code{"logical"}}

\item{\code{IndicatorMatrix}}{The indicator matrix dervied from the data matrix, class \code{"matrix"}}

\item{\code{Jk}}{The number of classes for each variable, class \code{"numeric"}}

\item{\code{p}}{The number of variables, class \code{"numeric"}}

\item{\code{mcalikertnoise}}{The noise value used in the experimental method to bootstrap an indicator or doubled matrix, class \code{"numeric"}}

\item{\code{mcaadjustinertias}}{Whether MCA inertias were adjusted, class \code{"logical"}}

\item{\code{mcauseadjustinertiasum}}{Whether the adjusted MCA inertia sum was used, class \code{"logical"}}

\item{\code{mcaadjustcoords}}{Whether the MCA coordinates were adjusted, class \code{"logical"}}

\item{\code{mcaadjustmassctr}}{Whether the MCA masses and contributions were adjusted, class \code{"logical"}}

\item{\code{mcasupplementary}}{How supplementary points were calculated when bootstrapping a Burt matrix, class \code{"character"}}
}}

\seealso{
\code{\linkS4class{cabasicresults}}
}
