% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myresamplefn.R
\name{myresamplefn}
\alias{myresamplefn}
\title{Example of a user-generated resampling routine.}
\usage{
myresamplefn(X)
}
\arguments{
\item{X}{a data matrix, to be resampled from}
}
\value{
a resampled version of the input data matrix
}
\description{
\code{myresamplefn} in this case assumes that each pair of cells represents 50 people
answering yes or no to a question, with undecideds not recorded
}
\details{
This is only intended as an example of a user-generated resampling routine,
users should replace it with their own function of this name

In this example we assume that rows groups of 50 people have each been
asked columns/2 questions, with possible answers yes/no/undecided.
It uses binomial bootstrapping for pairs of columns, assuming that
successive columns are "yes" and "no" answers, with others undecided,
with sums of pairs of columns having a maximum, in this case 50.
}
\examples{
# Five groups of people answer two yes/no/undecided questions
# Note: this is just an example, and does not intend to claim that this
# is the correct analysis for such a data set

x <- as.matrix( rbind( c(22,25,18,22), c(12,23,21,27),
                       c(31,12,28,22), c(29,14,35,11), c(7,31,12,21)))
xresampled <- myresamplefn(x)
bmr <- cabootcrs(x,"myresample",nboots=199)

}
\seealso{
\code{\link{cabootcrs-package}}, \code{\link{cabootcrs}}
}
