% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effect.R
\name{plot_effect}
\alias{plot_effect}
\title{Density Plot for the Main Effect}
\usage{
plot_effect(cacc_matrix, iv, value)
}
\arguments{
\item{cacc_matrix}{A tibble. The output of the \code{cacc} function.}

\item{iv}{A single variable name contained in a \code{cacc_matrix}.}

\item{value}{A single numeric or character value the \code{iv} specified can take.}
}
\value{
Returns a ggplot object.
}
\description{
Plots an annotated boxplot and kernel density estimate to visualize the distribution of the main effect that a specific value of a variable produces on the outcome probability in a \code{cacc_matrix}.
}
\examples{
plot_effect(
  cacc_matrix = cacc(onharassment, ivs = sex:privacy, dv = rep_victim),
  iv = age,
  value = "15-17"
)
}
\references{
Hart, T. C., Rennison, C. M., & Miethe, T. D. (2017). Identifying Patterns of Situational Clustering and Contextual Variability in Criminological Data: An Overview of Conjunctive Analysis of  Case  Configurations. \emph{Journal  of  Contemporary Criminal  Justice, 33}(2),  112–120. https://doi.org/10.1177/1043986216689746
}
