% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_stat.R
\name{stat_mcr}
\alias{stat_mcr}
\title{Matched callback rates}
\usage{
stat_mcr(x, level = 0.95)
}
\arguments{
\item{x}{a \code{callback} object.}

\item{level}{a number, containing the level of the confidence intervals (0.95
by default).}
}
\value{
A list with class \code{"stat_mcr"} containing 8 components: level, props, cp,
 wilson, student, t.fisher, t.pearson and t.student.


 \code{level:} the level of the confidence intervals.

 \code{props}: a data frame containing the following variables:
 \itemize{
  \item\bold{tests:} number of tests.
  \item\bold{p_callback:} overall callback rate.
  \item\bold{p_cand1:} 1st candidate callback rate.
  \item\bold{p_cand_dif:} p_cand1-p_cand2.
 }

\code{cp}: A data frame containing the Clopper-Pearson confidence intervals,
from binom.test().
 \itemize{
  \item\bold{inf_p_callback:} overall callback rate, lower bound.
  \item\bold{p_callback:} overall callback rate.
  \item\bold{sup_p_callback:} overall callback rate, upper bound.
  \item{inf_p_cand1:} 1st candidate callback rate, lower bound.
  \item\bold{p_cand1:} 1st candidate callback rate.
  \item\bold{sup_p_cand1:} 1st candidate callback rate, upper bound.
  \item\bold{inf_p_cand2:} 2nd candidate callback rate, lower bound.
  \item\bold{p_cand2:} 2nd candidate callback rate.
  \item\bold{sup_p_cand2:} 2nd candidate callback rate, upper bound.
  \item\bold{inf_cand_dif:} p_cand1-p_cand2, lower bound.
  \item\bold{sup_cand_dif:} p_cand1-p_cand2, upper bound.
 }

\code{wilson}: a data frame containing the Wilson confidence intervals,
 from prop.test().
 \itemize{
 \item\bold{inf_p_callback:} overall callback rate, lower bound.
 \item\bold{p_callback:} overall callback rate.
 \item\bold{sup_p_callback:} overall callback rate, upper bound.
 \item\bold{inf_p_cand1:} 1st candidate callback rate, lower bound.
 \item\bold{p_cand1:} 1st candidate callback rate.
 \item\bold{sup_p_cand1:} 1st candidate callback rate, upper bound.
 \item\bold{inf_p_cand2:} 2nd candidate callback rate, lower bound.
 \item\bold{p_cand2:} 2nd candidate callback rate.
 \item\bold{sup_p_cand2:} 2nd candidate callback rate, upper bound.
 \item\bold{inf_cand_dif:} p_cand1-p_cand2, lower bound.
 \item\bold{sup_cand_dif:} p_cand1-p_cand2, upper bound.
 }

\code{student}: a data frame containing the Student confidence intervals,
from t.test().
 \itemize{
  \item\bold{inf_p_callback:} overall callback rate, lower bound.
  \item\bold{p_callback:} overall callback rate.
  \item\bold{sup_p_callback:} overall callback rate, upper bound.
  \item\bold{inf_p_cand1:} 1st candidate callback rate, lower bound.
  \item\bold{p_cand1:} 1st candidate callback rate.
  \item\bold{sup_p_cand1:} 1st candidate callback rate, upper bound.
  \item\bold{inf_p_cand2:} 2nd candidate callback rate, lower bound.
  \item\bold{p_cand2:} 2nd candidate callback rate.
  \item\bold{sup_p_cand2:} 2nd candidate callback rate, upper bound.
  \item\bold{inf_cand_dif:} p_cand1-p_cand2, lower bound.
  \item\bold{sup_cand_dif:} p_cand1-p_cand2, upper bound.
 }

\code{t.fisher}: a data frame containing the statistics of the Fisher test.
 \itemize{
  \item\bold{p_cand_dif:} callback proportion difference between the candidates.
  \item\bold{p_Fisher:} the p-value of the Fisher test.
  \item\bold{s_Fisher:} the significance code of the Fisher test.
   }

\code{t.pearson}: a data frame containing the statistics of the Pearson test.
 \itemize{
  \item\bold{p_cand_dif:} callback proportion difference between the candidates.
  \item\bold{Pearson:} the value of Pearson's chi-squared test statistic.
  \item\bold{p_Pearson:} the p-value of the Pearson test.
  \item\bold{s_Pearson:} the significance code of the Pearson test.
   }

\code{t.student}: A data frame containing the statistics of the Student test.
 \itemize{
  \item\bold{p_cand_dif:} callback proportion difference between the candidates.
  \item\bold{Student:} the value of Student's test statistic.
  \item\bold{p_Student:} the p-value of the Student test.
  \item\bold{s_Student:} the significance code of the Student test.
   }
}
\description{
Computes the callback rates and their confidence intervals.
}
\examples{
data(labour1)
x <- callback(data=labour1,cluster="offer",candid="hist",callback="callback")
str(stat_mcr(x,level=0.9))

}
\references{
Clopper, C. J. & Pearson, E. S. (1934). The use of confidence or fiducial
limits illustrated in the case of the binomial. Biometrika, 26, 404–413.
doi:10.2307/2331986.

Wilson, E.B. (1927). Probable inference, the law of succession, and
statistical inference. Journal of the American Statistical Association, 22,
209–212. doi:10.2307/2276774.
}
\author{
Emmanuel Duguet
}
