% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulateDelegateCore}
\alias{simulateDelegateCore}
\title{Simulation delegate core (single replicate).}
\usage{
simulateDelegateCore(
  model,
  dataset,
  dest,
  events,
  tablefun,
  outvars,
  outfun,
  seed,
  replicates,
  nocb,
  dosing,
  replicate,
  iterations,
  ...
)
}
\arguments{
\item{model}{generic CAMPSIS model}

\item{dataset}{CAMPSIS dataset or 2-dimensional table}

\item{dest}{destination simulation engine, default is 'RxODE'}

\item{events}{interruption events}

\item{tablefun}{function or lambda formula to apply on exported 2-dimensional dataset}

\item{outvars}{variables to output in resulting dataframe}

\item{outfun}{function or lambda formula to apply on resulting dataframe after each replicate}

\item{seed}{seed value}

\item{replicates}{number of replicates, default is 1}

\item{nocb}{next-observation carried backward mode (NOCB), default value is TRUE for mrgsolve, FALSE for RxODE}

\item{dosing}{output dosing information, default is FALSE}

\item{replicate}{current replicate number}

\item{iterations}{number of iterations}

\item{...}{optional arguments like 'declare' and 'nocbvars'}
}
\value{
a data frame with the results
}
\description{
Simulation delegate core (single replicate).
}
\keyword{internal}
