% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancensus.R
\name{get_census_geometry}
\alias{get_census_geometry}
\title{Deprecated, use `get_census` instead}
\source{
Census data and boundary geographies are reproduced and distributed on
an "as is" basis with the permission of Statistics Canada (Statistics Canada
2006; 2011; 2016).
}
\usage{
get_census_geometry(dataset, regions, level = NA, geo_format = "sf", ...)
}
\arguments{
\item{dataset}{A CensusMapper dataset identifier.}

\item{regions}{A named list of census regions to retrieve. Names must be valid census aggregation levels.}

\item{level}{The census aggregation level to retrieve, defaults to \code{"Regions"}. One of \code{"Regions"}, \code{"PR"}, \code{"CMA"}, \code{"CD"}, \code{"CSD"}, \code{"CT"} or \code{"DA"}.}

\item{geo_format}{By default is set to \code{NA} and appends no geographic information. To include geographic information with census data, specify one of either \code{"sf"} to return an \code{\link[sf]{sf}} object (requires the \code{sf} package) or \code{"sp"} to return a \code{\link[sp]{SpatialPolygonsDataFrame-class}} object (requires the \code{rgdal} package).}

\item{...}{Further arguments passed to \code{get_census}.}
}
\description{
This function will be removed in future versions.
}
\examples{
# Query the API for data geographies in Vancouver, at the census subdivision
# level:
\dontrun{
# Query the API for geographies in Vancouver, at the census subdivision
# level, and return the associated geography files in \code{sf} format:
census_data <- get_census(dataset='CA16', regions=list(CMA="59933"),
                          level='CSD', geo_format = "sf")
}
}
\keyword{internal}
