% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_vectors.R
\name{child_census_vectors}
\alias{child_census_vectors}
\title{List all child variables from vector hierarchies given either a list of Census
variables returned by
\code{list_census_vectors}, \code{search_census_vectors}, \code{find_census_vectors}, or a direct string reference to the vector code.}
\usage{
child_census_vectors(
  vector_list,
  leaves_only = FALSE,
  max_level = NA,
  keep_parent = FALSE
)
}
\arguments{
\item{vector_list}{the list of vectors to be used, either a character vector or a filtered tibble
as returned from \code{list_census_vectors}.}

\item{leaves_only}{boolean flag to indicate if only final leaf vectors should be returned,
i.e. terminal vectors that themselves do not have children.}

\item{max_level}{optional, maximum depth to look for child vectors. Default is \code{NA} and will return all
child census vectors.}

\item{keep_parent}{optional, also return parent vector in list of results. Default is set to \code{FALSE}.}
}
\description{
List all child variables from vector hierarchies given either a list of Census
variables returned by
\code{list_census_vectors}, \code{search_census_vectors}, \code{find_census_vectors}, or a direct string reference to the vector code.
}
\examples{

\dontrun{
# Query parent vectors directly using vector identifier
child_census_vectors("v_CA16_2510")


# Example using multiple vectors coerced into a list
child_census_vectors(c("v_CA16_2510","v_CA16_2511","v_CA16_2512"))

# or, equivalently
selected_vectors <- c("v_CA16_2510","v_CA16_2511","v_CA16_2512")
child_census_vectors(selected_vectors)

# Example using dplyr and piped arguments
library(dplyr, warn.conflicts = FALSE)

list_census_vectors("CA16") \%>\%
  filter(vector == "v_CA16_2510") \%>\%
  child_census_vectors(TRUE)

# this will return the equivalent of c("v_CA16_2510", child_census_vectors("v_CA16_2510"))
list_census_vectors("CA16") \%>\%
  filter(vector == "v_CA16_2510") \%>\%
  child_census_vectors(TRUE, keep_parent = TRUE)
}

}
