% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_elements_metadata.R
\name{get_data_elements_metadata}
\alias{get_data_elements_metadata}
\title{Get Data Elements Metadata}
\usage{
get_data_elements_metadata(element_ids = NULL, ...)
}
\arguments{
\item{element_ids}{A vector of specific data element IDs to retrieve. If NULL, all data elements will be retrieved.}

\item{...}{Other options that can be passed onto KHIS API.}
}
\value{
A tibble containing the following columns:
\itemize{
\item element_id - The unique identifier for the data element.
\item element    - The name of the data element.
}
}
\description{
\code{get_data_elements_metadata()} fetches data elements metadata from the KHIS API
server, including their IDs and names.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fetch the data element metadata for particular element id
elements <- get_data_elements_metadata(element_ids = c('htFuvGJRW1X'))
elements

# Fetch all the data elements
elements <- get_data_elements_metadata()
elements
\dontshow{\}) # examplesIf}
}
