% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_population.R
\name{target_population}
\alias{target_population}
\alias{get_cervical_target_population}
\alias{get_breast_cbe_target_population}
\alias{get_breast_mammogram_target_population}
\alias{get_colorectal_target_population}
\title{Screening Target Populations}
\usage{
get_cervical_target_population(year, level = c("kenya", "county", "subcounty"))

get_breast_cbe_target_population(
  year,
  level = c("kenya", "county", "subcounty")
)

get_breast_mammogram_target_population(
  year,
  level = c("kenya", "county", "subcounty")
)

get_colorectal_target_population(
  year,
  level = c("kenya", "county", "subcounty")
)
}
\arguments{
\item{year}{Year for which to estimate population.}

\item{level}{The desired level of the organization unit hierarchy to retrieve
data for: \code{"kenya"} (default) , \code{"county"} or \code{"subcounty"}.}
}
\value{
A tibble containing the target screening population
\itemize{
\item county     - name of the county. Optional if the level is county or subcounty
\item subcounty  - name of the county. Optional if the level if subcounty
\item target     - number to be screened
}

A tibble containing the target screening population

A tibble containing the target screening population

A tibble containing the target screening population
}
\description{
These functions subsets the Kenyan population to the desirable screening population.
}
\details{
\code{get_cervical_target_population()} subsets the target population for cervical
cancer screening: females aged between 25 years and 50 years

\code{get_breast_cbe_target_population()} subsets the target population for clinical
breast examination: females aged between 25 years and 74 years

\code{get_breast_mammogram_target_population()} subsets the target population for
breast cancer screening through mammography: females aged between 40 years to 74 years

\code{get_colorectal_target_population()} subsets the target population for
colorectal cancer screening: males and females aged between 45 years to 75 years

These target populations are guided by the
\href{https://www.iccp-portal.org/system/files/plans/KENYA\%20NATIONAL\%20CANCER\%20CONTROL\%20STRATEGY\%202017-2022_1.pdf}{Kenya National Cancer Screening Guidelines 2018}.
The population projection for counties and the national level are calculated
based on population growth 2.2\% obtained from the \href{https://www.knbs.or.ke/}{Kenya National Bureau of Statistics}.
The annual targets follows the guidance of screening guidelines and for cervical
cancer it is also guided by the WHO publication 'Planning and implementing
cervical cancer prevention programs: A manual for managers.'
}
\examples{
# Get the country projection for cervical cancer screening for the year 2024
target_population <- get_cervical_target_population(2024)
target_population

# Get the projection for cervical cancer screening for 2022 by county
target_population <- get_cervical_target_population(2022, level = 'county')
target_population

# Get the projection for CBE for 2022 by county
target_population <- get_breast_cbe_target_population(2022, level = 'county')
target_population

# Get the country projection of women to perform mammogram for the year 2024
target_population <- get_breast_mammogram_target_population(2024)
target_population

# Get the country projection colorectal cancer screening for the year 2024
target_population <- get_colorectal_target_population(2024)
target_population

}
