% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_parquet.R
\name{collect_and_normalize}
\alias{collect_and_normalize}
\title{Collect data from a parquet, feather or sqlite query and normalize cansim table output}
\usage{
collect_and_normalize(
  connection,
  replacement_value = "val_norm",
  normalize_percent = TRUE,
  default_month = "07",
  default_day = "01",
  factors = TRUE,
  strip_classification_code = FALSE,
  disconnect = FALSE
)
}
\arguments{
\item{connection}{A connection to a local arrow connection as returned by \code{get_cansim_connection},
possibly with filters or other \code{dplyr} verbs applied}

\item{replacement_value}{(Optional) the name of the column the manipulated value should be returned in. Defaults to adding the `val_norm` value field.}

\item{normalize_percent}{(Optional) When \code{true} (the default) normalizes percentages by changing them to rates}

\item{default_month}{The default month that should be used when creating Date objects for annual data (default set to "07")}

\item{default_day}{The default day of the month that should be used when creating Date objects for monthly data (default set to "01")}

\item{factors}{(Optional) Logical value indicating if dimensions should be converted to factors. (Default set to \code{FALSE}).}

\item{strip_classification_code}{(Optional) Logical value indicating if classification code should be stripped from names. (Default set to \code{false}).}

\item{disconnect}{(Optional) Only used when format is sqlite. Logical value to indicate if the SQLite database connection should be disconnected. (Default is \code{FALSE})}
}
\value{
A tibble with the collected and normalized data
}
\description{
Collect data from a parquet, feather or sqlite query and normalize cansim table output
}
\examples{
\dontrun{
library(dplyr)

con <- get_cansim_connection("34-10-0013")
data <- con \%>\%
  filter(GEO=="Ontario") \%>\%
  collect_and_normalize()

}
}
