% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_vectors.R
\name{get_cansim_vector_for_latest_periods}
\alias{get_cansim_vector_for_latest_periods}
\title{Retrieve data for specified Statistics Canada data vector(s) for last N periods}
\usage{
get_cansim_vector_for_latest_periods(
  vectors,
  periods = NULL,
  language = "english",
  refresh = FALSE,
  timeout = 200,
  factors = TRUE,
  default_month = "07",
  default_day = "01"
)
}
\arguments{
\item{vectors}{The list of vectors to retrieve}

\item{periods}{Numeric value for number of latest periods to retrieve data for, but default all data is retrieved.}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (defaults to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}

\item{factors}{(Optional) Logical value indicating if dimensions should be converted to factors. (Default set to \code{TRUE}).}

\item{default_month}{The default month that should be used when creating Date objects for annual data (default set to "07")}

\item{default_day}{The default day of the month that should be used when creating Date objects for monthly data (default set to "01")}
}
\value{
A tibble with data for specified vector(s) for the last N periods
}
\description{
Allows for the retrieval of data for specified vector series for the N most-recently released periods.
Accessing data by vector allows for targeted extraction of time series. Discovering vectors of interest can be achieved
using the StatCan table web interface or using \code{get_cansim_table_template}
function to help pinpoint data series of interest, and then chaining the \code{add_cansim_vectors_to_template} function to add
cansim vector information to the template data.
The StatCan API can only process 300 coordinates at a time,
if more than 300 coordinates are specified the function will batch the requests to the API.
}
\examples{
\dontrun{
get_cansim_vector_for_latest_periods("v41690973",10)
}
}
