% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plink2cape.R
\name{plink2cape}
\alias{plink2cape}
\title{Convert plink2 files to cape format}
\usage{
plink2cape(
  ped = "test.ped",
  map = "test.map",
  pheno = "test.pheno",
  out = "out.csv",
  missing_genotype = "0",
  no_fid = FALSE,
  no_parents = FALSE,
  no_sex = FALSE,
  no_pheno = FALSE,
  verbose = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{ped}{full path to the ped file}

\item{map}{full path to the map file}

\item{pheno}{full path to the pheno file}

\item{out}{full path to the output file}

\item{missing_genotype}{default is "0"}

\item{no_fid}{boolean, default is FALSE}

\item{no_parents}{boolean, default is FALSE}

\item{no_sex}{boolean, default is FALSE}

\item{no_pheno}{boolean, default is FALSE}

\item{verbose}{boolean, default is FALSE, gives some happy little progress messages}

\item{overwrite}{boolean, default is FALSE, will only remove the existing file if this is set to TRUE}
}
\value{
A list with two elements: data_obj and geno_obj
These objects are formatted for use in cape and must then
be separated to use in \code{\link{run_cape}}.
}
\description{
Convert plink2 files to cape format
}
\details{
For further information about PLINK and its file formats,
see \url{https://zzz.bwh.harvard.edu/plink/}
}
\examples{
\dontrun{
#convert files with default names to a data_obj
data_obj <- plink2cape()
}
}
\references{
Purcell S, Neale B, Todd-Brown K, Thomas L, Ferreira MAR, 
Bender D, Maller J, Sklar P, de Bakker PIW, Daly MJ & Sham PC (2007) 
PLINK: a toolset for whole-genome association and population-based 
linkage analysis. American Journal of Human Genetics, 81.
}
