% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pheno.R
\name{get_pheno}
\alias{get_pheno}
\title{Get the phenotype matrix}
\usage{
get_pheno(
  data_obj,
  scan_what = c("eigentraits", "normalized_traits", "raw_traits"),
  covar = NULL
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{scan_what}{A character string. One of "eigentraits", "normalized.trait",
or "raw_traits." If "eigentraits" the function returns the eigentraits matrix.
If "normalized_traits" the function returns the trait matrix after mean-centering
and normalizing. If "raw.trait" the function returns the trait matrix before 
mean-centering and normalization were applied.}

\item{covar}{A character value indicating which, if any, covariates the traits
should be adjusted for. If covariates are specified, the function fits a linear
model to specify the traits with the covariates and returns the matrix of residuals
(i.e. the traits after adjusting for the covariates).}
}
\value{
A matrix in which each column is a trait, and each row is an individual.
The values correspond to the argument settings described above.
}
\description{
This function can return a number of different trait matrices
depending on the arguments.
}
