% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_pheno.R
\name{select_pheno}
\alias{select_pheno}
\title{This function selects the phenotypes in a Cape object}
\usage{
select_pheno(
  data_obj,
  pheno_which,
  min_entries = 5,
  scale_pheno = FALSE,
  rank_norm_pheno = FALSE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{pheno_which}{vector of names from the parameters YAML file.
This vector should include both traits and covariates. The covariates
are assigned after trait selection.}

\item{min_entries}{minimum number of data entries the phenotype needs 
to have for it to be included. If any trait has fewer than min_entries,
It will be removed with a warning.}

\item{scale_pheno}{if TRUE then phenotypes are mean-centered and standardized}

\item{rank_norm_pheno}{if TRUE then phenotypes are rank Z normalized}
}
\value{
updated \code{\link{Cape}} object
}
\description{
Updates the pheno object to include only `pheno_which` columns.
Optionally scale and/or normalize traits.
}
\examples{
\dontrun{
data_obj <- select_pheno(data_obj, pheno_which = c("BW_24", "INS_24", "log_GLU_24"))
}

}
