% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.feglm}
\alias{autoplot.feglm}
\alias{autoplot.felm}
\title{Autoplot method for feglm objects}
\usage{
\method{autoplot}{feglm}(object, ...)

\method{autoplot}{felm}(object, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{...}{Additional arguments passed to the method. In this case,
the additional argument is \code{conf_level}, which is the confidence level for
the confidence interval.}
}
\value{
A ggplot object with the estimated coefficients and their confidence
intervals.

A ggplot object with the estimated coefficients and their confidence
intervals.
}
\description{
Extracts the estimated coefficients and their confidence
intervals.

Extracts the estimated coefficients and their confidence
}
\examples{
set.seed(123)
trade_2006 <- trade_panel[trade_panel$year == 2006, ]
trade_2006 <- trade_2006[sample(nrow(trade_2006), 500), ]

mod <- fepoisson(
  trade ~ log_dist + lang + cntg + clny | exp_year + imp_year,
  trade_2006
)

autoplot(mod, conf_level = 0.99)

set.seed(123)
trade_2006 <- trade_panel[trade_panel$year == 2006, ]
trade_2006 <- trade_2006[trade_2006$trade > 0, ]
trade_2006 <- trade_2006[sample(nrow(trade_2006), 500), ]
trade_2006$log_trade <- log(trade_2006$trade)

mod <- felm(
  log_trade ~ log_dist + lang + cntg + clny | exp_year + imp_year,
  trade_2006
)

autoplot(mod, conf_level = 0.90)

}
