% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ferry_emissions.R
\name{ferry_emissions}
\alias{ferry_emissions}
\title{Calculate CO2e emissions from ferry journeys}
\usage{
ferry_emissions(
  from,
  to,
  via = NULL,
  type = c("Foot", "Car", "Average"),
  num_people = 1,
  times_journey = 1,
  include_WTT = TRUE,
  round_trip = FALSE
)
}
\arguments{
\item{from}{Port code for the port departing from. Use \code{seaport_finder} to find port code.}

\item{to}{Port code for the port arriving from. Use \code{seaport_finder} to find port code.}

\item{via}{Optional. Takes a vector containing the port code that the ferry travels through. Use \code{seaport_finder} to find port code.}

\item{type}{Whether the journey is taken on foot or by car. Options are \code{"Foot"}, \code{"Car"}, \code{"Average"}.}

\item{num_people}{Number of people taking the journey. Takes a single numerical value.}

\item{times_journey}{Number of times the journey is taken.}

\item{include_WTT}{logical. Recommended \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}

\item{round_trip}{Whether the journey is one-way or return.}
}
\value{
Returns CO2e emissions in tonnes for the ferry journey.
}
\description{
A function that calculates CO2e emissions between ferry ports.
}
\details{
The distances are calculated using the Haversine formula. This is calculated as the crow flies.
}
\examples{
# Emissions for a ferry journey between Belfast and New York City
seaport_finder(city = "Belfast")
seaport_finder(city = "New York")
ferry_emissions(from = "BEL", to = "BOY")
}
