% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_noise_dims}
\alias{gen_noise_dims}
\title{Generate Random Noise Dimensions}
\usage{
gen_noise_dims(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The number of observations for which to generate noise dimensions.}

\item{num_noise}{The number of noise dimensions to generate.}

\item{min_n}{The minimum value for the random noise.}

\item{max_n}{The maximum value for the random noise.}
}
\value{
A matrix containing the generated random noise dimensions.
}
\description{
This function generates random noise dimensions to be added to the coordinates of a sphere.
}
\examples{
# Generate random noise dimensions with 3 dimensions, minimum value -1, and maximum value 1
set.seed(20240412)
gen_noise_dims(n = 50, num_noise = 3, min_n = -0.01, max_n = 0.01)

}
