% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{plane}
\alias{plane}
\title{Generate points on a plane in 2D space}
\usage{
plane(
  n,
  coef_x1,
  coef_x2,
  coef_y1,
  coef_y2,
  intercept_x,
  intercept_y,
  u_min,
  u_max,
  v_min,
  v_max,
  num_noise,
  min_n,
  max_n
)
}
\arguments{
\item{n}{The number of points to generate.}

\item{coef_x1}{The coefficient of the first parameter in the x-dimension equation.}

\item{coef_x2}{The coefficient of the second parameter in the x-dimension equation.}

\item{coef_y1}{The coefficient of the first parameter in the y-dimension equation.}

\item{coef_y2}{The coefficient of the second parameter in the y-dimension equation.}

\item{intercept_x}{The intercept for the x-dimension equation.}

\item{intercept_y}{The intercept for the y-dimension equation.}

\item{u_min}{The minimum value for the first parameter (u) range.}

\item{u_max}{The maximum value for the first parameter (u) range.}

\item{v_min}{The minimum value for the second parameter (v) range.}

\item{v_max}{The maximum value for the second parameter (v) range.}

\item{num_noise}{The number of noise dimensions to add to the generated points.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the generated points on the plane.
}
\description{
This function generates points on a plane in 3D space based on the provided coefficients,
intercepts, and ranges for the parameters.
}
\examples{
set.seed(20240412)
plane_points <- plane(
  n = 100, coef_x1 = 1, coef_x2 = 1,
  coef_y1 = -1, coef_y2 = 1, intercept_x = -10,
  intercept_y = 8, u_min = 10, u_max = 30, v_min = 10, v_max = 20,
  num_noise = 2, min_n = -0.05, max_n = 0.05
)

}
